// $Id: CFloat.cpp,v 1.4 2007/02/08 21:06:44 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CFloat.hpp"
using Exponent::Basics::CFloat;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CFloat, CCountedObject);

//	===========================================================================
CFloat::CFloat(const float value) : m_value(0.f)
{
	EXPONENT_CLASS_CONSTRUCTION(CFloat);
	this->setValue(value);
}

//	===========================================================================
CFloat::~CFloat()
{
	EXPONENT_CLASS_DESTRUCTION(CFloat);
	// Nothing to do...
}

//	===========================================================================
void CFloat::setValue(const CFloat &value)
{
	this->setValue(value.getValue());
}

//	===========================================================================
void CFloat::setValue(const float value)
{
	m_value = value;
}

//	===========================================================================
float CFloat::getValue() const
{
	return m_value;
}

//	===========================================================================
CString CFloat::getValueAsString(const long decimalPlaces) const
{
	// First we store a string that has the first part of the final string
	char flag[256] = "%.0";

	// Now store the position
	char buffer[20];
	sprintf(buffer, "%li", decimalPlaces);

	// Copy the decimal places to the end of the flag
	strcat(flag, buffer);

	// Now copy in the format flag
	strcat(flag, "f");

	// Create the string
	CString string;

	// Set teh string
	string.setStringWithFormat(flag, m_value);

	// Return the string
	return string;
}

//	===========================================================================
CFloat &CFloat::operator = (const CFloat &value)
{
	m_value = value.getValue();
	return (*this);
}

//	===========================================================================
CFloat &CFloat::operator = (const float value)
{
	m_value = value;
	return (*this);
}

//	===========================================================================
bool CFloat::operator == (const CFloat &value)
{
	return (m_value == value.getValue());
}

//	===========================================================================
bool CFloat::operator == (const float value)
{
	return (m_value == value);
}

//	===========================================================================
bool CFloat::operator != (const CFloat &value)
{
	return (m_value != value.getValue());
}

//	===========================================================================
bool CFloat::operator != (const float value)
{
	return (m_value != value);
}

//	===========================================================================
CFloat &CFloat::operator + (const CFloat &value)
{
	m_value += value.getValue();
	return (*this);
}

//	===========================================================================
CFloat &CFloat::operator + (const float value)
{
	m_value += value;
	return (*this);
}

//	===========================================================================
CFloat &CFloat::operator - (const CFloat &value)
{
	m_value -= value.getValue();
	return (*this);
}

//	===========================================================================
CFloat &CFloat::operator - (const float value)
{
	m_value -= value;
	return (*this);
}

//	===========================================================================
CFloat &CFloat::operator * (const CFloat &value)
{
	m_value *= value.getValue();
	return (*this);
}

//	===========================================================================
CFloat &CFloat::operator * (const float value)
{
	m_value *= value;
	return (*this);
}

//	===========================================================================
CFloat &CFloat::operator / (const CFloat &value)
{
	const float val = value.getValue();
	if (val != 0.f)
	{
		m_value /= val;
	}
	else
	{
		m_value = 0.f;
	}
	return (*this);
}

//	===========================================================================
CFloat &CFloat::operator / (const float value)
{
	if (value != 0.f)
	{
		m_value /= value;
	}
	else
	{
		m_value = 0.f;
	}
	return (*this);
}

//	===========================================================================
CFloat &CFloat::operator += (const CFloat &value)
{
	m_value += value.getValue();
	return (*this);
}

//	===========================================================================
CFloat &CFloat::operator += (const float value)
{
	m_value += value;
	return (*this);
}

//	===========================================================================
CFloat &CFloat::operator -= (const CFloat &value)
{
	m_value -= value.getValue();
	return (*this);
}

//	===========================================================================
CFloat &CFloat::operator -= (const float value)
{
	m_value -= value;
	return (*this);
}

//	===========================================================================
bool CFloat::operator ! ()
{
	return (m_value == 0.f);
}

//	===========================================================================
void CFloat::getObjectDescription(char *string, const long size) const
{
	this->getValueAsString().getString(string, size);
}